/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.flashlauncher;

import edu.colorado.phet.flashlauncher.util.BareBonesBrowserLaunch;
import edu.colorado.phet.flashlauncher.util.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class FlashLauncher {
    private static final String ARGS_FILENAME = "flash-launcher-args.txt";
    private static final String HTML_TEMPLATE = "flash-launcher-template.html";
    private static final String VERSION_FORMAT = "{0}.{1}.{2} ({3})";
    private String sim;
    private String language;
    private static JTextArea jTextArea;

    public FlashLauncher() throws IOException {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(ARGS_FILENAME);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = bufferedReader.readLine();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        FlashLauncher.println("line = " + string);
        this.sim = stringTokenizer.nextToken();
        this.language = stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreTokens() && stringTokenizer.nextToken().equals("-dev")) {
            FlashLauncher.println("FlashLauncher.FlashLauncher dev");
            JFrame jFrame = new JFrame("Text");
            jTextArea = new JTextArea(10, 50);
            jFrame.setContentPane(new JScrollPane(jTextArea));
            jFrame.setVisible(true);
            jFrame.setDefaultCloseOperation(3);
            jFrame.setSize(800, 600);
        }
    }

    public static void println(String string) {
        System.out.println(string);
        if (jTextArea != null) {
            jTextArea.append(string + "\n");
        }
    }

    public static void main(String[] stringArray) throws IOException {
        new FlashLauncher().start();
    }

    private void start() throws IOException {
        FlashLauncher.println("FlashLauncher.start");
        FlashLauncher.println("System.getProperty( \"user.dir\" ) = " + System.getProperty("user.dir"));
        File file = new File(System.getProperty("user.dir"));
        File file2 = new File(file, "temp-" + this.sim + "-phet");
        File file3 = this.getJARFile();
        FlashLauncher.println("jarfile = " + file3);
        FlashLauncher.println("Starting unzip jarfile=" + file3 + ", tempDir=" + file2);
        FileUtils.unzip(file3, file2);
        FlashLauncher.println("Finished unzip");
        Properties properties = FlashLauncher.readProperties(this.sim);
        String string = FlashLauncher.readVersion(properties);
        String string2 = FlashLauncher.readBackgroundColor(properties);
        String string3 = FlashLauncher.generateHTML(this.sim, this.language, string, string2);
        File file4 = new File(file2, this.sim + "_" + this.language + ".html");
        FileOutputStream fileOutputStream = new FileOutputStream(file4);
        fileOutputStream.write(string3.getBytes());
        fileOutputStream.close();
        FlashLauncher.println("Starting openurl");
        BareBonesBrowserLaunch.openURL("file://" + file4.getAbsolutePath());
    }

    private static Properties readProperties(String string) {
        String string2 = string + ".properties";
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string2);
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return properties;
    }

    private static String readVersion(Properties properties) {
        String string = null;
        String string2 = properties.getProperty("version.major");
        String string3 = properties.getProperty("version.minor");
        String string4 = properties.getProperty("version.dev");
        String string5 = properties.getProperty("version.revision");
        Object[] objectArray = new Object[]{string2, string3, string4, string5};
        string = MessageFormat.format(VERSION_FORMAT, objectArray);
        return string;
    }

    private static String readBackgroundColor(Properties properties) {
        String string = properties.getProperty("bgcolor");
        if (string == null) {
            string = "#ffffff";
        }
        return string;
    }

    private static String generateHTML(String string, String string2, String string3, String string4) throws IOException {
        String string5 = "";
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(HTML_TEMPLATE);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string6 = bufferedReader.readLine();
        while (string6 != null) {
            string5 = string5 + string6;
            string6 = bufferedReader.readLine();
            if (string6 == null) continue;
            string5 = string5 + System.getProperty("line.separator");
        }
        string5 = string5.replaceAll("@SIM@", string);
        string5 = string5.replaceAll("@LANGUAGE@", string2);
        string5 = string5.replaceAll("@VERSION@", string3);
        string5 = string5.replaceAll("@BGCOLOR@", string4);
        return string5;
    }

    private File getJARFile() {
        URL uRL = FlashLauncher.class.getProtectionDomain().getCodeSource().getLocation();
        try {
            URI uRI = new URI(uRL.toString());
            return new File(uRI.getPath());
        }
        catch (URISyntaxException uRISyntaxException) {
            FlashLauncher.println(uRISyntaxException.getMessage());
            uRISyntaxException.printStackTrace();
            throw new RuntimeException(uRISyntaxException);
        }
    }
}

